<?php

header('Content-Type: application/json');

require_once('../config.php');
require_once "../function/database.php";
require_once "../function/handler.php";
require_once "../api/api.php";

$api = @new api();
@$db = new db();
$media = @new media();
$bot = @new hkbot($Token);
@$mysqli = new mysqli($localhost, $db_username, $db_password, $db_name);
@$mysqli->set_charset('utf8mb4');


function showResult($status, $p2keyvalue, $json_format = 64|128|256){
    $json_show = json_encode([
        'status' => $status,
        $p2keyvalue[0] => $p2keyvalue[1]
    ], $json_format);
    echo $json_show;
    exit();
}

$_Method = isset($_POST['key']) ? $_POST : $_GET;

$api_key = (isset($_Method['key']) and !empty($_Method['key'])) ? $_Method['key'] : null;
$action =  (isset($_Method['action']) and !empty($_Method['action'])) ? $_Method['action'] : null;
$serviceid = (isset($_Method['service']) and !empty($_Method['service'])) ? $_Method['service'] : null;
$link = (isset($_Method['link']) and !empty($_Method['link'])) ? $_Method['link'] : null;
$quantity = (isset($_Method['quantity']) and !empty($_Method['quantity'])) ? $_Method['quantity'] : null;
$orderID = (isset($_Method['order']) and !empty($_Method['order'])) ? $_Method['order'] : null;

if ($api_key == null)
{
    showResult('failed', ['error', 'apikey parametr not exist']);
}

elseif ($action == null)
{
    showResult('failed', ['error', 'action parametr not exist']);
}

$api_existing = $mysqli->query("SELECT * FROM `licences` WHERE `licence` = '$api_key' LIMIT 1");

if (mysqli_num_rows($api_existing) == 0)
{
    showResult('failed', ['error', 'your licence not exist']);
}

$fetch_api_info = mysqli_fetch_assoc($api_existing);
$api_userid = $fetch_api_info['userid'];
$admin = @$db->notuser($api_userid, "works");
@$ban = $mysqli->query("SELECT `id` FROM `banlist` WHERE `id` = '$api_userid' LIMIT 1")->num_rows;

if ($ban == 1) {
    exit("you are banned");
}

if (in_array($api_userid, $admins) || $admin == 1) {
$home = $media->keyboards(["home1"]);
$home["keyboard"][] = [["text" => "پنل"]];
$home = json_encode($home);
} else {
$home = json_encode($media->keyboards(["home1"]));
}

$get_userinfo = $mysqli->query("SELECT * FROM `users` WHERE `id` = $api_userid LIMIT 1")->fetch_assoc();

if ($action == 'balance')
{
    showResult('success', ['balance', $get_userinfo['balance']]);
}

elseif ($action == 'services')
{
    $all_servs = [];
    $all_created_btns_unauto = $mysqli->query("SELECT * FROM `button` WHERE `off` = 1 AND `type` = 0");
    foreach($all_created_btns_unauto as $one_created_btn0){
        $sood = floor($one_created_btn0['sood'] / 2);
        $prr = $one_created_btn0['price'] + ($one_created_btn0['price'] * $sood / 100);
        $all_servs[] = [
            'service' => '10'.$one_created_btn0['id'],
            'name' => $one_created_btn0['text'],
            'min' => $one_created_btn0['min'],
            'max' => $one_created_btn0['max'],
            'type' => 'Exclusive SmmProduct',
            'category' => $one_created_btn0['category'],
            'rate' => $prr,
            'desc' => $one_created_btn0['info']
        ];
    }
    echo json_encode($all_servs, 64|128|256);
    exit;
}

elseif ($action == 'add')
{
    if ($link == null)
    {
        showResult('failed', ['error', 'link parametr not exist']);
    }
    elseif(!(preg_match("/^[a-zA-Z0-9$-\/:-?@{-~!\"^_`\[\] ]+$/", $link))){
        showResult('failed', ['error', 'Link error, Enter English Only...!']);
    }
    elseif ($quantity == null or !preg_match('/^\d*$/', $quantity))
    {
        showResult('failed', ['error', 'quantity parametr not exist or was not number']);
    }
    elseif ($serviceid == null or !preg_match('/^\d*$/', $serviceid))
    {
        showResult('failed', ['error', 'service parametr not exist or was not number']);
    }

    $strchring = substr($serviceid, 0, 2);
    $clean_service_code = substr_replace("$serviceid", '', 0, 2);
    if ($strchring == 10)
    {
        $get_order = $mysqli->query("SELECT * FROM `button` WHERE `id` = $clean_service_code AND `off` = 1 AND `type` = 0 LIMIT 1");
    }

    if (mysqli_num_rows($get_order) == 0)
    {
        showResult('failed', ['error', 'service id is wrong']);
    }

    $get_order = mysqli_fetch_assoc($get_order);

    $minimum = $get_order['min'];
    $maximum = $get_order['max'];
    $product_title = $get_order['text'];
    $sood = isset($get_order['sood']) ? $get_order['sood'] : 0;
    $product_price = $get_order['price'] + ($get_order['price'] * $sood / 100);
    $product_info = $get_order['info'];
    $my_factor = $quantity / 1000 * $product_price;
    $usercoin = $get_userinfo['balance'];
    $count = $quantity;

    if ($quantity >= $minimum and $quantity <= $maximum)
    {
        if ($usercoin >= $my_factor)
        {

            if ($strchring == 10)
            {
                
                $getchat = $bot->getChat($api_userid);
                $first_name = $getchat->first_name;
                $newmoj = $get_userinfo['balance'] - $my_factor;
                if ($get_order['api'] == 'noapi')
                {
                
                    $order = $db->listorder("Pending", $api_userid, 0, $count, $link, $my_factor, $product_title, $date, "noapi");
                    if ($order["result"] == "OK") {
                    $orderid = $order["code"];
                    $channels = $db->info(1, "channel");
                    $bot->sendMessage($channels["channelorder2"], $media->text(["api_order_receipt2", $product_title, $first_name, $api_userid, $count, $link, $orderid, $my_factor, $date, $get_userinfo['balance'], $newmoj]), json_encode(["inline_keyboard" => [[["text" => "در انتظار", "callback_data" => "go-" . $orderid], ["text" => (int) $orderid, "callback_data" => "fyk"]], [["text" => (int) $orderid, "callback_data" => "fyk"], ["text" => "کنسل کردن سفارش", "callback_data" => "can-" . $orderid]]]]));
                    if ($off["okorder"] == 1) {
                    $GetINFObot = $bot->bot('getMe');
                    $idbot = $GetINFObot->result->username;
                    $bot->sendMessage($channels["channelokorder"], $media->text(["api_order_receipt0", $get_order['category'], $product_title, $count, $my_factor, $date, $idbot]), json_encode(["inline_keyboard" => [[["text" => $key["startbot"], "url" => "https://t.me/" . $idbot . "?start"]]]]));
                    }
                    $bot->sendMessage($api_userid, $media->text(["api_order_receipt_oknoapi", $get_order['category'], $product_title, $link, $count, $orderid, $date]), $home);
                    } else {
                    $db->update("users", ["step" => "none"], $api_userid, ["s"]);
                    $bot->sendMessage($api_userid, "3-".$media->text(["error_order"]), $home);
                    showResult('failed', ['error', $media->text(["error_order"])]);
                    }
                    
                }else{
                    
                    $infoapi = $db->info($get_order["api"], "api", "name", "s");

                    if ($infoapi !== false) {
                        $res = $api->add_order($infoapi["smartpanel"], $infoapi["name"], $infoapi["api_url"], $infoapi["api_key"], $get_order["serviceid"], $link, $count);
                        $orderidapi = $res["code"] ?? $res['order'];
                        if ($res["status"] == "OK" and is_numeric($orderidapi)) {
                            $order = $db->listorder("Pending", $api_userid, $orderidapi, $count, $link, $my_factor, $product_title, $date, $get_order["api"]);
                            
                            if ($order["result"] == "OK") {
                                $orderid = $order["code"];
                                $oldmoj = $get_userinfo["balance"];
                                $bot->sendMessage($channels["channelorder1"], $media->text(["api_order_receipt1", $product_title, $first_name, $api_userid, $count, $link, $orderid, $orderidapi, $my_factor, $date, $oldmoj, $newmoj]), json_encode(["inline_keyboard" => [[["text" => (int) $orderid, "callback_data" => "fyk"], ["text" => "ارسال شد - api", "callback_data" => "fyk"]], [["text" => "پیگیری سفارش", "callback_data" => "peygiri-" . $orderidapi]]]]));
                                if ($off["okorder"] == 1) {
                                    $bot->sendMessage($channels["channelokorder"], $media->text(["api_order_receipt0", $get_order['category'], $product_title, $count, $my_factor, $date, $idbot]), json_encode(["inline_keyboard" => [[["text" => $key["startbot"], "url" => "https://t.me/" . $idbot . "?start"]]]]));
                                }
                                $bot->sendMessage($api_userid, $media->text(["api_order_receipt_okapi", $get_order['category'], $product_title, $link, $count, $orderid, $orderidapi, $date]), $home);
                            } else {
                                $db->update("users", ["step" => "none"], $api_userid, ["s"]);
                                $bot->sendMessage($api_userid, "0-".$media->text(["error_order"]), $home);
                                showResult('failed', ['error', $media->text(["error_order"])]);
                            }
                        } else {
                            $tx = "شرح مشکل :" . $res["error"];
                            $bot->sendMessage($admins[0], "1 ->> مشکل در ثبت سفارشی : \nمحصول : " . $product_title . "\n" . $tx);
                            $db->update("users", ["step" => "none"], $api_userid, ["s"]);
                            $bot->sendMessage($api_userid, "1-".$media->text(["error_order"]), $home);
                            showResult('failed', ['error', $media->text(["error_order"])]);
                        }
                    } else {
                        $db->update("button", ["off" => 0], $info["id"], ["i"]);
                        $bot->sendMessage($admins[0], "2->> مشکل در ثبت سفارشی : \nمحصول : " . $product_title . "\napi این محصول در دیتابیس یافت نشد و محصول خاموش شد.");
                        $db->update("users", ["step" => "none"], $api_userid, ["s"]);
                        $bot->sendMessage($api_userid, "2-".$media->text(["error_order"]), $home);
                        showResult('failed', ['error', $media->text(["error_order"])]);
                    }
                    
                }
                    
            }

        }
        else
        {
            sendMessage($api_userid, "عدم موجودی کافی برای ثبت سفارش به مبلغ $my_factor تومان از طریق وبسرویس.
- اعتبار فعلی شما : {$get_userinfo['balance']} تومان

لطفا جهت ثبت شدن سفارشات بعدی موجودی خود را در ربات افزایش دهید...!");
            showResult('failed', ['error', "Your Inventory is not enough"]);
        }
    }
    else
    {
        showResult('failed', ['error', "Count must be fewer of $maximum and biggest than $minimum"]);
    }

    $allord = $get_userinfo['all_orders'] + 1;
    $allpay = $get_userinfo['all_pay'] + $my_factor;
    $mysqli->query("UPDATE `users` SET `balance` = `balance` - $my_factor, `all_orders`='$allord', `all_pay`='$allpay' WHERE `id` = '$api_userid' LIMIT 1");
    $setting = $db->info(1, "setting");
    $allord1 = $setting['all_orders'] + 1;
    $allpay2 = $setting['all_pay'] + $my_factor;
    $mysqli->query("UPDATE `setting` SET `all_orders`='$allord1',`all_pay`='$allpay2' WHERE `id`='1' LIMIT 1");
    $new_coin = $get_userinfo['balance'] - $my_factor;
    $code = isset($orderid) ? $orderid : $ordr;
    /*$bot->sendMessage($api_userid, "$my_factor از موجودی شما به دلیل ثبت سفارش با api ربات کم شد

نام محصول: $product_title
جزییات محصول: $product_info
کد پیگیری: $code
موجودی قبلی شما: {$get_userinfo['balance']}
موجودی فعلی شما:‌ $new_coin");*/
    $json_show = json_encode([
        'status' => 'success',
        'description' => 'Order Registered Successfully',
        'order' => $code,
        'count' => $count,
        'title' => $product_title,
        'price' => $my_factor,
        'info' => $product_info
    ], 64|128|256);
    echo $json_show;
    exit();

}

elseif ($action == 'status')
{

    if ($orderID == null)
    {
        showResult('failed', ['error', 'order parametr not exist']);
    }

    $get_order_exist = $mysqli->query("SELECT * FROM `list` WHERE `code` = '$orderID' AND `chatid` = $api_userid LIMIT 1");

    if (mysqli_num_rows($get_order_exist) == 0)
    {
        showResult('failed', ['error', "You Have'nt any order by this order id"]);
    }

    $fetch_order = mysqli_fetch_assoc($get_order_exist);

    $order_status = $fetch_order['status'] == 'Completed' ? 'Completed' : $fetch_order['status'];

    $json_show = json_encode([
        'order' => $orderID,
        'name' => $fetch_order['sefaresh'],
        'status' => $order_status,
        'count' => $fetch_order['count'],
        'link' => $fetch_order['link'],
        'price' => $fetch_order['factor']
    ], 64|128|256);
    echo $json_show;
    exit();

}

?>